	var validations = {
		req: function(data){
			return (data != '' && data.length > 0);
		},
		numeric: function(data){
			re = /^\d+(\.\d+)*$/;
			return re.test(data);
		},
		email: function validateEmail(email) {
			var re = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
			return re.test(email);
		},
		bic: function(data){
			re = /^([a-zA-Z]){4}([a-zA-Z]){2}([0-9a-zA-Z]){2}([0-9a-zA-Z]{3})?$/;
			return re.test(data);
		},
		iban: function(data){
			re = /^IE\d{2}[A-Z]{4}\d{14}$/;
			return re.test(data);
		},
		len: function(data){
			re = /^([a-zA-Z0-9_-]){4,10}$/;
			return re.test(data);
		},	
		text: function(data){
			re = /^([a-zA-Z0-9- ]+)$/;
			return re.test(data);
		},
		// day between 1 and 31
		engine_cc: function(data){
			re = /^[0-9]{3,4}$/;
			return re.test(data);
		},		
		// day between 1 and 31
		day: function(data){
			re = /^([1-9]|[12]\d|3[0-1])$/;
			return re.test(data);
		},
		month: function(data){
			return (data != '' && data.length > 0);
		},		
		// date between 1920 and 2000
		year: function(data){
			re = /^19[2-9]\d|20[0-4]\d|2000$/;
			return re.test(data);
		}		





		
	}
	$(document).ready(function(){
		function addError(fname, error){
			$('[name=' + fname + ']').after('<span class="validationError"> ' + error + '</span>');
		}
		function removeError(fname){
			$('[name=' + fname + ']').parent('div').find('.validationError').remove();
		}
		var map = {};
		for(var x in validationRules){
			var fname = validationRules[x][0];
			if(typeof fname == 'undefined') continue;
			if(typeof map[fname] == 'undefined') map[fname] = [];
			map[fname].push({
				'method' : validationRules[x][1],
				'error' : validationRules[x][2]
			});
		};
		for(var x in map){
			$('[name=' + x + ']').on('keyup', function(){			
				var fname = $(this).attr('name'),
					validators = map[fname];
				removeError(fname);				
				for(var y in validators){
					if(typeof validators[y] == 'function') continue;				
					if(!validations[validators[y].method]($(this).val())) addError(fname, validators[y].error);
				}
			});
		}
		$('#send, #insert').on('click', function(ev){		
			var isOk = true;
			$('.validationError').remove();			
			for(var x in map){
				for(var y in map[x]){
					if(typeof map[x][y] == 'function' || !$('[name=' + x + ']').is(':visible')) continue;
					
					if(!validations[map[x][y].method]($('[name=' + x + ']').val())){
						addError(x, map[x][y].error);
						isOk = false;
					}
				}
			};
			return isOk;
		});
	});