<?php

use Tygh\Registry;

if (!defined('BOOTSTRAP')) { die('Access denied'); }

if (defined('PAYMENT_NOTIFICATION')) {
	$payment_id = db_get_field("SELECT payment_id FROM ?:orders WHERE order_id = ?i", $_REQUEST['order_id']);

	$processor_data = fn_get_payment_method_data($payment_id);

	if($_REQUEST['RESPONSECODE'] == "A") {
		$pp_response['order_status'] = 'P';
		$pp_response["reason_text"] = "Auth Code: " . $_REQUEST['APPROVALCODE'];
	} else {
		$pp_response['order_status'] = 'F';
		$pp_response["reason_text"] = "Bank Response: " . $_REQUEST['RESPONSETEXT'];
	}

	fn_finish_payment($_REQUEST['order_id'], $pp_response, false);
	fn_order_placement_routines('route', $_REQUEST['order_id']);
} else {
	$currency = $order_info['secondary_currency'];
	
	switch ($currency) {
	    case $processor_data['processor_params']['currency_one'] :
	        $terminalID = $processor_data['processor_params']['terminal_id_one'];
	        $sharedSecret = $processor_data['processor_params']['shared_secret_one'];
		break;
	    case $processor_data['processor_params']['currency_two'] :
	        $terminalID = $processor_data['processor_params']['terminal_id_two'];
	        $sharedSecret = $processor_data['processor_params']['shared_secret_two'];
		break;
	    case $processor_data['processor_params']['currency_three'] :
	        $terminalID = $processor_data['processor_params']['terminal_id_three'];
	        $sharedSecret = $processor_data['processor_params']['shared_secret_three'];
		break;
	    default:
	        die("ERROR: Cart Currency not configured for WorldNet Payment plug-in. Transaction not processed. Please contact site administrator.");
	}

	$paymentpage_url = "https://" . ($processor_data['processor_params']['test'] == '1' ? 'test' : '') . $processor_data['processor_params']['gateway'] . "/merchant/paymentpage";
	
	$_order_id = ($order_info['repaid']) ? ($order_id .'_'. $order_info['repaid']) : $order_id;
	
	$receiptPageURL = fn_url("payment_notification.finish?payment=worldnettpshpp&order_id={$_order_id}", AREA, 'current');
	$amount = $order_info['total'];

	$dateTime = date('d-m-Y:H:i:s:000');
	$hash = md5($terminalID . $_order_id . $amount . $dateTime . $receiptPageURL . $sharedSecret);

	$msg = fn_get_lang_var('text_cc_processor_connection');
	$msg = str_replace('[processor]', 'WorldNet HPP', $msg);
	
	$post["TERMINALID"] = $terminalID;
	$post["CURRENCY"] = $currency;
	$post["ORDERID"] = $_order_id;
	$post["DATETIME"] = $dateTime;
	if($processor_data['processor_params']['send_email'] == "1") {
		$post["EMAIL"] = $order_info['email'];
	}
	if($processor_data['processor_params']['avs'] == "1") {
		$post["ADDRESS1"] = $order_info['b_address'];
		$post["ADDRESS2"] = $order_info['b_city'] . ", " . $order_info['b_state'];
		$post["POSTCODE"] = $order_info['b_zipcode'];
	}
	$post["AMOUNT"] = $amount;
	$post["RECEIPTPAGEURL"] = $receiptPageURL;
	$post["HASH"] = $hash;
	
	fn_create_payment_form($paymentpage_url, $post, 'WorldNet Hosted Payment Page');
}
exit;
