<?php
/*
Plugin Name: Hikashop WorldNet Payments (XML)
Plugin URI: http://www.worldnettps.com/
Description: Extension for Hikashop with WorldNet TPS Hosted Payment Page redirect gateway.
Version: 1.0
Author: Namita Kapoor (WorldNet TPS)
Author URI: http://www.worldnettps.com/
License: GNU General Public License v3.0
License URI: http://www.gnu.org/licenses/gpl-3.0.html
*/

/*  Copyright 2016  WorldNEt TPS  (email: support@worldnettps.com)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

defined('_JEXEC') or die('Restricted access');
?><?php
require_once 'worldnettps_configuration.php';
class plgHikashoppaymentWorldnettps extends hikashopPaymentPlugin
{       var $sale = null;
	var $accepted_currencies = array('EUR','GBP','USD','AUD','CAD','DKK','SEK','NOK');
	var $multiple = true;
	var $name = 'worldnettps';
	var $doc_form = 'worldnettps';
	var $pluginConfig = array(
		
		'gateway' => array('Gateway','list', array(
					'worldnet' => 'WorldNetTPS',
					'cashflows' => 'CashFlows','payius' => 'Payius',
					'pagotechnology' => 'PagoTechnology',
					'globalone' => 'GlobalOnePay',
					'anywherecommerce' => 'AnywhereCommerce',
					'ctpayment' => 'CT-Payments',
					'payzone' => 'Payzone',
					'payconex' => 'PayConex')),
                'mode' => array('Test/Live Mode','list', array(
					'Test' => 'Test',
					'Live' => 'Live')),
                'terminal_id' => array('TerminalID', 'input'),
		'secret_key' => array('Shared Secret', 'input'),
                'avs' => array('AVS','list', array(
					'1' => 'Enabled',
					'0' => 'Disabled')),
                'debug' => array('DEBUG', 'boolean','0'),
		'ask_ccv' => array('CARD_VALIDATION_CODE', 'boolean','1'),
		'ask_owner' => array('CREDIT_CARD_OWNER', 'boolean','0'),
		'ask_cctype' => array('CARD_TYPE', 'big-textarea'),
		//'invalid_status' => array('INVALID_STATUS', 'orderstatus'),
		//'verified_status' => array('VERIFIED_STATUS', 'orderstatus')
        
	);

	function __construct(&$subject, $config)
	{
		return parent::__construct($subject, $config);
	}

	function needCC(&$method)
	{
		$method->ask_cc=true;
		$method->ask_ccv = @$method->payment_params->ask_ccv;
		$method->ask_owner = @$method->payment_params->ask_owner;
		$method->ask_cctype = @$method->payment_params->ask_cctype;
		if(!empty($method->ask_cctype)){
			$types = explode(',',$method->ask_cctype);
			$method->ask_cctype = array();
			foreach($types as $type){
				$method->ask_cctype[$type]=$type;
			}
		}
		return true;
	}


	function onBeforeOrderCreate(&$order,&$do)
	{
		if(parent::onBeforeOrderCreate($order, $do) === true)
			return true;

		if(!function_exists('curl_init'))
		{
			$this->app->enqueueMessage('The Payment Express payment plugin needs the CURL library installed but it seems that it is not available on your server. Please contact your web hosting to set it up.','error');
			return false;
		}

		if(empty($this->payment_params->terminal_id) || empty($this->payment_params->secret_key))
		{
			$this->app->enqueueMessage('Please check your &quot;WorldNet&quot; plugin configuration : the Terminal ID and the secret key need to be configured.');
			$do = false;
		}

	}

	function onAfterOrderConfirm(&$order, &$methods, $method_id)
	{
		parent::onAfterOrderConfirm($order, $methods, $method_id);
		$cancel_url = HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=order&task=cancel_order&order_id='.$order->order_id.$this->url_itemid;
		$return_url = HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id='.$order->order_id.$this->url_itemid;


		$this->ccLoad();
		$cc_number=$this->cc_number;
		$cc_owner=$this->cc_owner;
		$cc_month=$this->cc_month;
		$cc_year=$this->cc_year;
		$cc_type=@$this->cc_type;
		$cc_ccv=@$this->cc_CCV;
                $address1 = '';
                if(!empty($order->cart->billing_address->address_street)){
				$address1 = substr($order->cart->billing_address->address_street,0,200);
			} 
                $address2 = @$order->cart->billing_address->address_city.",".@$order->cart->billing_address->address_state->zone_code_3;
		$postcode = @$order->cart->billing_address->address_post_code;

                $terminalID = $this->payment_params->terminal_id;     
                $gateway = $this->payment_params->gateway;
                $sharedsecret = $this->payment_params->secret_key;
                $testaccount = $this->payment_params->mode;
                $debug = $this->payment_params->debug;  
		$expiry_date =$cc_month.$cc_year;
		$order_id = $order->order_id;
                $currency = $this->currency->currency_code;
		$amout = round($order->cart->full_total->prices[0]->price_value_with_tax,2);
		$date = date('d-m-Y:H:i:s').':000';
		
                $order_id = (int)@$order->order_id;
              /**  $strDescription = '';
		foreach($order->cart->products as $objItem){
			$strDescription .= $objItem->order_product_name;
			if($objItem->order_product_quantity > 1)
				$strDescription .= "*".$objItem->order_product_quantity;
			$strDescription .= "; ";
		}
                $email = $order->cart->customer->email;    
               **/ 
		
		$sale = new XmlAuthRequest($terminalID, $order_id , $currency, $amout, $cc_number, $cc_type, $expiry_date);
                
		 if ($cc_ccv != '') {
                    
		    $sale->SetCvv($cc_ccv);
                    
		}
                if ($this->payment_params->avs == '1') {
                    
		    $sale->SetAvs($address1, $address2, $postcode);
                    
		}
                $sale->SetNonSecureCardCardInfo($expiry_date, $cc_owner);
               
		$response = $sale->ProcessRequest($sharedsecret,$testaccount,$gateway);
                             
	
		if ($response)
		{
			
			if ($response->IsError())
			{
				if ($this->payment_params->debug)
					if($cc_owner == '')
                                          {
                                            echo 'ERROR : Card Holder Name is Expected.';
    					  }
					else
                                         {	
					echo 'ERROR : '.$response->ErrorString();
                                         }
					
				return false;
			}
			else
			{
				$response->{"TERMINALID"} = $this->payment_params->terminal_id;
				$response->{"AMOUNT"} = $amout;
				$hash = $this->hash_generator($this->payment_params->secret_key,$response,$this->payment_params->debug);
                                echo $hash; 
				if (strcasecmp($hash,$response->HASH())!=0)
				{
					if($this->payment_params->debug)
						echo 'Hash error '.$response->Hash().' - '.$hash."\n\n\n";
					$this->modifyOrder($order->order_id, $this->payment_params->invalid_status, true, true);
					$this->app->enqueueMessage('The generated Hash is not valid. Please make sure that you entered a valid secredt key in the options of the WorldNet TPS payment method.','error');
					$this->app->redirect($cancel_url);
					return false;
				}
				elseif ($response->ResponseCode()!='A' || $response->ResponseText()!='APPROVAL')
				{
                                        
					if($this->payment_params->debug)
						echo 'payment '.$response->ResponseText()."\n\n\n";
					//$this->modifyOrder($order->order_id, $this->payment_params->invalid_status, true, true);
					$this->app->redirect($cancel_url);
					return false;
				}
				else
				{       
					//$this->modifyOrder($order->order_id, $this->payment_params->verified_status, true, true);
					$this->app->redirect($return_url);
					return true;
				}
			}
		}
		

	}

	function onPaymentConfiguration(&$element){
		parent::onPaymentConfiguration($element);
	}

	function getPaymentDefaultValues(&$element) {
		$element->payment_name = 'WorldNetTPS XML Payment';
		$element->payment_description = 'You can pay by credit card using this payment method';
		$element->payment_images = 'MasterCard,VISA,Credit_card';
		$element->payment_params->debug=false;
		$element->payment_params->invalid_status='cancelled';
		$element->payment_params->verified_status='confirmed';
		$element->payment_params->pending_status='created';
		$element->payment_params->ask_cctype='VISA,VISA DEBIT,ELECTRON,MASTERCARD,DEBIT MASTERCARD,MAESTRO,LASER,AMEX,DINERS,JCB,DISCOVER';
		//$element->payment_params->invalid_status = 'cancelled';
		//$element->payment_params->verified_status = 'confirmed';
	}

	function hash_generator($secret, $parameters, $debug=false)
	{
		$clear_string = '';
		$clear_string = $parameters->TERMINALID.$parameters->UniqueRef().$parameters->AMOUNT.$parameters->DateTime().$parameters->ResponseCode().$parameters->ResponseText().$secret;
				
		if (PHP_VERSION_ID < 50102) //Php >= 5.1.2 needed
		{
			$this->app->enqueueMessage('The WorldNetTPS payment plugin requires at least the PHP 5.1.2 version to work, but it seems that it is not available on your server. Please contact your web hosting to set it up.','error');
			return false;
		}
		else
		{
			if($debug) echo 'Hash : '.$clear_string;
			return hash('md5', $clear_string);
		}
	}

	
}
