<?php
/*
  $
*/

class worldnet_xml
{
  var $code, $title, $description, $enabled;
  var $oid;

  function worldnet_xml()
  {
    global $order;

    $this->code        = 'worldnet_xml';
    $this->title       = MODULE_PAYMENT_TEXT_WORLDNETXML_TITLE;
    $this->description = MODULE_PAYMENT_TEXT_WORLDNETXML_DESCRIPTION;
    $this->sort_order  = MODULE_PAYMENT_WORLDNETXML_SORT_ORDER;
    $this->enabled     = ((MODULE_PAYMENT_WORLDNETXML_STATUS == 'True') ? true : false);
    $this->pci         = false;

    if( (int)MODULE_PAYMENT_WORLDNETXML_ORDER_STATUS_ID > 0 )
    {
      $this->order_status = MODULE_PAYMENT_WORLDNETXML_ORDER_STATUS_ID;
    }

    if(is_object($order))
      $this->update_status();
  }

  // class methods
  function update_status()
  {
    global $db;
    global $order;

    if( ($this->enabled == true) && ((int)MODULE_PAYMENT_WORLDNETXML_ZONE > 0) )
    {
      $check_flag = false;
      $check = $db->Execute("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_WORLDNETXML_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
      while (!$check->EOF)
      {
        if ($check['zone_id'] < 1)
        {
          $check_flag = true;
          break;
        } 
        elseif ($check['zone_id'] == $order->billing['zone_id'])
        {
          $check_flag = true;
          break;
        }
  $check->MoveNext();
      }

      if($check_flag == false)
      {
        $this->enabled = false;
      }
    }
  }

  function javascript_validation() {
    $js = '  if (payment_value == "' . $this->code . '") {' . "\n" .
    '    var cc_owner = document.checkout_payment.worldnetxml_cc_owner.value;' . "\n" .
    '    var cc_number = document.checkout_payment.worldnetxml_cc_number.value;' . "\n".
    '    var cc_cvv = document.checkout_payment.worldnetxml_cc_cvv.value;' . "\n" .
    '    if (cc_owner == "" || cc_owner.length < ' . CC_OWNER_MIN_LENGTH . ') {' . "\n" .
    '      error_message = error_message + "' . MODULE_PAYMENT_TEXT_WORLDNETXML_JS_CC_OWNER . '";' . "\n" .
    '      error = 1;' . "\n" .
    '    }' . "\n" .
    '    if (cc_number == "" || cc_number.length < ' . CC_NUMBER_MIN_LENGTH . ') {' . "\n" .
    '      error_message = error_message + "' . MODULE_PAYMENT_TEXT_WORLDNETXML_JS_CC_NUMBER . '";' . "\n" .
    '      error = 1;' . "\n" .
    '    }' . "\n" .
    '    if (cc_cvv == "" || cc_cvv.length < "3" || cc_cvv.length > "4") {' . "\n" .
    '      error_message = error_message + "' . MODULE_PAYMENT_TEXT_WORLDNETXML_JS_CC_CVV . '";' . "\n" .
    '      error = 1;' . "\n" .
    '    }' . "\n" .
    '  }' . "\n";

    return $js;
  }

  /**
   * Display Credit Card Information Submission Fields on the Checkout Payment Page
   *
   * @return array
   */
  function selection() {
    global $order;

    for ($i=1; $i<13; $i++) {
      $expires_month[] = array('id' => sprintf('%02d', $i), 'text' => strftime('%B - (%m)',mktime(0,0,0,$i,1,2000)));
    }

    $today = getdate();
    for ($i=$today['year']; $i < $today['year']+15; $i++) {
      $expires_year[] = array('id' => strftime('%y',mktime(0,0,0,1,1,$i)), 'text' => strftime('%Y',mktime(0,0,0,1,1,$i)));
    }
    $onFocus = ' onfocus="methodSelect(\'pmt-' . $this->code . '\')"';

    $selection = array('id' => $this->code,
                       'module' => MODULE_PAYMENT_TEXT_WORLDNETXML_TITLE,
                       'fields' => array(array('title' => MODULE_PAYMENT_TEXT_WORLDNETXML_CARDHOLDERNAME,
                                               'field' => zen_draw_input_field('worldnetxml_cc_owner', $order->billing['firstname'] . ' ' . $order->billing['lastname'], 'id="'.$this->code.'-cc-owner"'. $onFocus . ' autocomplete="off"'),
                                               'tag' => $this->code.'-cc-owner'),
                                         array('title' => MODULE_PAYMENT_TEXT_WORLDNETXML_CARD_NUMBER,
                                               'field' => zen_draw_input_field('worldnetxml_cc_number', '', 'id="'.$this->code.'-cc-number"' . $onFocus . ' autocomplete="off"'),
                                               'tag' => $this->code.'-cc-number'),
                                         array('title' => MODULE_PAYMENT_TEXT_WORLDNETXML_CARD_EXPIRY,
                                               'field' => zen_draw_pull_down_menu('worldnetxml_cc_expires_month', $expires_month, strftime('%m'), 'id="'.$this->code.'-cc-expires-month"' . $onFocus) . '&nbsp;' . zen_draw_pull_down_menu('worldnetxml_cc_expires_year', $expires_year, '', 'id="'.$this->code.'-cc-expires-year"' . $onFocus),
                                               'tag' => $this->code.'-cc-expires-month')));

      $selection['fields'][] = array('title' => MODULE_PAYMENT_TEXT_WORLDNETXML_CARD_CVV,
                                   'field' => zen_draw_input_field('worldnetxml_cc_cvv', '', 'size="4", maxlength="4"' . ' id="'.$this->code.'-cc-cvv"' . $onFocus . ' autocomplete="off"') . ' ' . '<a href="javascript:popupWindow(\'' . zen_href_link(FILENAME_POPUP_CVV_HELP) . '\')">' . MODULE_PAYMENT_TEXT_WORLDNETXML_CARD_CVV_WHATS_THIS . '</a>',
                                   'tag' => $this->code.'-cc-cvv');

    return $selection;
  }
  function pre_confirmation_check() {
    global $messageStack;

    include(DIR_WS_CLASSES . 'cc_validation.php');

    $cc_validation = new cc_validation();
    $result = $cc_validation->validate($_POST['worldnetxml_cc_number'], $_POST['worldnetxml_cc_expires_month'], $_POST['worldnetxml_cc_expires_year'], $_POST['worldnetxml_cc_cvv']);
    $error = '';
    switch ($result) {
      case -1:
      $error = sprintf(TEXT_CCVAL_ERROR_UNKNOWN_CARD, substr($cc_validation->cc_number, 0, 4));
      break;
      case -2:
      case -3:
      case -4:
      $error = TEXT_CCVAL_ERROR_INVALID_DATE;
      break;
      case false:
      $error = TEXT_CCVAL_ERROR_INVALID_NUMBER;
      break;
    }

    if ( ($result == false) || ($result < 1) ) {
      $messageStack->add_session('checkout_payment', $error . '<!-- ['.$this->code.'] -->', 'error');
      zen_redirect(zen_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL', true, false));
    }

    $this->cc_card_type = $cc_validation->cc_type;
    $this->cc_card_number = $cc_validation->cc_number;
    $this->cc_expiry_month = $cc_validation->cc_expiry_month;
    $this->cc_expiry_year = $cc_validation->cc_expiry_year;
  }

  function confirmation() {
    $confirmation = array('fields' => array(array('title' => MODULE_PAYMENT_TEXT_WORLDNETXML_CREDIT_CARD_TYPE,
                                                  'field' => $this->cc_card_type),
                                            array('title' => MODULE_PAYMENT_TEXT_WORLDNETXML_CARDHOLDERNAME,
                                                  'field' => $_POST['worldnetxml_cc_owner']),
                                            array('title' => MODULE_PAYMENT_TEXT_WORLDNETXML_CARD_NUMBER,
                                                  'field' => substr($this->cc_card_number, 0, 6) . str_repeat('X', (strlen($this->cc_card_number) - 10)) . substr($this->cc_card_number, -4)),
                                            array('title' => MODULE_PAYMENT_TEXT_WORLDNETXML_CARD_EXPIRY,
                                                  'field' => strftime('%B, %Y', mktime(0,0,0,$_POST['worldnetxml_cc_expires_month'], 1, '20' . $_POST['worldnetxml_cc_expires_year']))) ));
    return $confirmation;
  }

  function process_button() {
    $process_button_string = zen_draw_hidden_field('cc_owner', $_POST['worldnetxml_cc_owner']) .
                             zen_draw_hidden_field('cc_expires', $this->cc_expiry_month . substr($this->cc_expiry_year, -2)) .
                             zen_draw_hidden_field('cc_type', $this->cc_card_type) .
                             zen_draw_hidden_field('cc_number', $this->cc_card_number) .
                             zen_draw_hidden_field('cc_cvv', $_POST['worldnetxml_cc_cvv']);
    return $process_button_string;
  }

  function before_process() {
    global $response, $db, $order, $messageStack;
    
    include(DIR_FS_CATALOG . DIR_WS_MODULES . 'payment/worldnettps/worldnet_tps_xml.php');

    if ($order->info['currency'] == MODULE_PAYMENT_WORLDNETXML_CURRENCY_2)
    {
        $terminalid = MODULE_PAYMENT_WORLDNETXML_ID_2;
  	$secret     = MODULE_PAYMENT_WORLDNETXML_SECRET_2;
    }
    else
    {
        $terminalid = MODULE_PAYMENT_WORLDNETXML_ID;
 	$secret     = MODULE_PAYMENT_WORLDNETXML_SECRET;
    }

    mt_srand((double)microtime()*1000000);

    $datetime = strftime("%d-%m-%Y:%H:%M:%S").":".mt_rand(1, 999);
    $orderId = strftime("%H%M%S"). mt_rand(100000, 999999);
    $email = $order->customer['email_address'];

    $amount = number_format($order->info['total'], 2);
    $hash = md5($terminalid . $orderid . $amount . $datetime . $receiptPageURL . $secret);

    $n=sizeof($order->products);
    $orderString = 'Product Count: ' . $n . '<br /><br />';
    for ($i=0; $i<$n; $i++) {
        $orderString .= 'Product ID: ' . zen_get_prid($order->products[$i]['id']) . '<br />Model: ' . $order->products[$i]['model'] . '<br />Name: ' . $order->products[$i]['name'] . '<br />Quantity: ' . $order->products[$i]['qty'] . '<br />Price: ' . $order->products[$i]['final_price'] . '<br /><br />';
    }


    # Set up the authorisation object
    $auth = new XmlAuthRequest($terminalid, $orderId, $order->info['currency'], $amount, $_POST['cc_number'], strtoupper($_POST['cc_type']));
    $auth->SetCvv($_POST['cc_cvv']);
    //$auth->SetAvs($order->billing['street_address'], $order->billing['city'].', '.$order->billing['state'],$order->billing['postcode']);
    $auth->SetEmail($email);
    $auth->SetDescription($orderString);
    $auth->SetNonSecureCardCardInfo($_POST['cc_expires'], $_POST['cc_owner']);

    # Perform the online authorisation and read in the result
    $response = $auth->ProcessRequestToGateway($secret, (MODULE_PAYMENT_WORLDNETXML_TEST_MODE == "Yes" ? true : false), MODULE_PAYMENT_WORLDNETXML_GATEWAY);

    $expectedResponseHash = md5($terminalid . $orderId . $amount . $response->DateTime() . $response->ResponseCode() . $response->ResponseText() . $secret);

    if($response->IsError()) {
      $messageStack->add_session('checkout_payment', 'AN ERROR OCCURED! You transaction was not processed. Error details: ' . $response->ErrorString(), 'error');
      zen_redirect(zen_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL', true, false));
    } elseif($expectedResponseHash == $response->Hash()) {
      switch($response->ResponseCode()) {
        case "A" :
            $this->transaction_id = $orderId;
            $this->auth_code = $response->ApprovalCode();
            break;
        case "R" :
        case "D" :
        case "C" :
        case "S" :
        default  :
            $messageStack->add_session('checkout_payment', 'PAYMENT DECLINED! Please try again with another card. Bank response: ' . $response->ResponseText(), 'caution');
            zen_redirect(zen_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL', true, false));
      }
    } else {
      $messageStack->add_session('checkout_payment', 'PAYMENT FAILED: INVALID RESPONSE HASH. Please contact <a href="mailto:' . $adminEmail . '">' . $adminEmail . '</a> or call ' . $adminPhone . ' to clarify if you will get charged for this order. Please quote WorldNet Terminal ID: ' . $terminalid . ', and Order ID: ' . $orderId . ' when mailing or calling.', 'error');
      zen_redirect(zen_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL', true, false));
    }
  }

  function after_process()
  {
    global $insert_id, $db;
    $sql = "insert into " . TABLE_ORDERS_STATUS_HISTORY . " (comments, orders_id, orders_status_id, customer_notified, date_added) values (:orderComments, :orderID, :orderStatus, -1, now() )";
    $sql = $db->bindVars($sql, ':orderComments', 'Credit Card payment.  Auth Code: ' . $this->auth_code . '. WorldNet Order ID: ' . $this->transaction_id . '.', 'string');
    $sql = $db->bindVars($sql, ':orderID', $insert_id, 'integer');
    $sql = $db->bindVars($sql, ':orderStatus', $this->order_status, 'integer');
    $db->Execute($sql);
    return false;
  }

  function get_error()
  {
    if (PHP_VERSION < 4.1)
    {
      global $_GET;
    }

    $error = array('title' => WORLDNETXML_ERROR_TITLE,
                   'error' => ((isset($_GET['error'])) ? stripslashes(urldecode($_GET['error'])) : IPAYMENT_ERROR_MESSAGE));

    return $error;
  }

  function output_error()
  {
    return false;
  }

  function check()
  {
    if(!isset($this->_check))
    {
  global $db;
      $check_query = $db->Execute("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_WORLDNETXML_STATUS'");
      $this->_check = $check_query->RecordCount();
    }
    return $this->_check;
  }

  function install()
  {
  global $db;
    $db->Execute(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES 
      (
        'Enable WorldNet TPS Module', 
        'MODULE_PAYMENT_WORLDNETXML_STATUS', 
        'True', 
        'Do you want to accept WorldNet TPS payments?', 
        '6', 
        '1', 
        'zen_cfg_select_option(array(\'True\', \'False\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Gateway',
        'MODULE_PAYMENT_WORLDNETXML_GATEWAY',
        'WorldNet',
        'Under which WorldNet gateway is your account?',
        '6',
        '2',
        'zen_cfg_select_option(array(\'WorldNet\',\'CashFlows\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Test Mode?',
        'MODULE_PAYMENT_WORLDNETXML_TEST_MODE',
        'Yes',
        'Are you in test or live mode?',
        '6',
        '3',
        'zen_cfg_select_option(array(\'Yes\',\'No\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'First Transaction Currency',
        'MODULE_PAYMENT_WORLDNETXML_CURRENCY',
        'Selected Currency',
        'The first currency to use for credit card transactions',
        '6',
        '4',
        'zen_cfg_select_option(array(\'EUR\',\'GBP\',\'USD\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES
      (
        'First Terminal ID',
        'MODULE_PAYMENT_WORLDNETXML_ID',
        'TerminalID 1',
        'The Terminal ID provided by WorldNet TPS for the first currency',
        '6',
        '5',
        now())");

    $db->Execute(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES 
      (
        'First Shared Secret', 
        'MODULE_PAYMENT_WORLDNETXML_SECRET', 
        'Secret', 
        'The Shared Secret provided by WorldNet TPS for the first currency',
        '6', 
        '6',
        now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Second Transaction Currency (if applicable)',
        'MODULE_PAYMENT_WORLDNETXML_CURRENCY_2',
        'Selected Currency',
        'The second currency to use for credit card transactions',
        '6',
        '7',
        'zen_cfg_select_option(array(\'EUR\',\'GBP\',\'USD\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES
      (
        'Second Terminal ID',
        'MODULE_PAYMENT_WORLDNETXML_ID_2',
        'TerminalID 2',
        'The Terminal ID provided by WorldNet TPS for the second currency',
        '6',
        '8',
        now())");

    $db->Execute(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES 
      (
        'Second Shared Secret', 
        'MODULE_PAYMENT_WORLDNETXML_SECRET_2', 
        'Secret', 
        'The Shared Secret provided by WorldNet TPS for the second currency',
        '6', 
        '9',
        now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Send receipt from WorldNet TPS host?',
        'MODULE_PAYMENT_WORLDNETXML_SEND_EMAIL',
        'No',
        'The WorldNet TPS host can send it\'s own non-configurable e-mail that only contains transaction information.',
        '6',
        '10',
        'zen_cfg_select_option(array(\'Yes\',\'No\'), ', now())");

$db->Execute(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES 
      (
        'Sort order of display.', 
        'MODULE_PAYMENT_WORLDNETXML_SORT_ORDER', 
        '0', 
        'Sort order of display. Lowest is displayed first.', 
        '6', 
        '11',
        now())");
  
    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added)
      VALUES
      (
        'Set Order Status',
        'MODULE_PAYMENT_WORLDNETXML_ORDER_STATUS_ID',
        '0',
        'Set the status of orders made with this payment module to this value',
        '6',
        '12',
        'zen_cfg_pull_down_order_statuses(', 'zen_get_order_status_name', now())");
  }

  function remove()
  {
  global $db;
    $db->Execute("delete from " . TABLE_CONFIGURATION . " where configuration_key like 'MODULE_PAYMENT_WORLDNETXML%';");
  }

  function keys()
  {
    return array(
      'MODULE_PAYMENT_WORLDNETXML_STATUS'              ,
      'MODULE_PAYMENT_WORLDNETXML_GATEWAY'             ,
      'MODULE_PAYMENT_WORLDNETXML_TEST_MODE'           ,
      'MODULE_PAYMENT_WORLDNETXML_CURRENCY'            ,
      'MODULE_PAYMENT_WORLDNETXML_ID'                  ,
      'MODULE_PAYMENT_WORLDNETXML_SECRET'              ,
      'MODULE_PAYMENT_WORLDNETXML_CURRENCY_2'          ,
      'MODULE_PAYMENT_WORLDNETXML_ID_2'                ,
      'MODULE_PAYMENT_WORLDNETXML_SECRET_2'            ,
      'MODULE_PAYMENT_WORLDNETXML_SEND_EMAIL'          ,
      'MODULE_PAYMENT_WORLDNETXML_ORDER_STATUS_ID'     ,
      'MODULE_PAYMENT_WORLDNETXML_SORT_ORDER');
  }
}

?>
