<?php

# This is the file that contains the account settings for WorldNet.
require('worldnet_account.inc');

# This is a helper file for intgerating to the WorldNet HPP in PHP.
require('worldnet_hpp_functions.inc');

# These values are specific to the transaction.
$orderId = '' . strip_tags($_POST['ORDERID']) . '';			# This should be unique per transaction.
$amount = '' . strip_tags($_POST['AMOUNT']) . '';			# This should include the decimal point.

$email = '' . strip_tags($_POST['EMAIL']) . '';					# (optional) If this is sent then WorldNet will send a receipt to this e-mail address.
$description = '' . strip_tags($_POST['DESCRIPTION']) . '';		# (optional) This can is a decription for the transaction that will be available in the merchant notification e-mail and in the SelfCare system.
# $phone = '' . strip_tags($_POST['PHONE']) . '';				# (optional) This can is a decription for the transaction that will be available in the merchant notification e-mail and in the SelfCare system.
$autoReady = '';												# (optional) Y or N. Automatically set the transaction to a status of Ready in the batch. If not present the terminal default will be used.

$cardholderName = '' . strip_tags($_POST['CARDHOLDERNAME']) . '';		# (optional) If the cardholders name is available it should be populated here. If so it will be pre-populated on the payment page.
$address1 = '';															# (optional) This is the first line of the cardholders billing address.
$address2 = '';															# (optional) This is the second line of the cardholders billing address.
$postcode = '';															# (optional) This is the postcode of the cardholders billing address.

$dateTime = requestDateTime();

# If there's no orderId set then generate a unique time-based order ID.
if(!isset($orderId) || $orderId == '') $orderId = generateUniqueOrderId();

# ------ Add order to the local database here if using one ------

# Verification string
$requestHash = authRequestHash($orderId, $amount, $dateTime);

# Write the HTML of the submission form
echo "<html><body><form id='worldnetform' action='" . requestURL() . "' method='post'>\n";
writeHiddenField("TERMINALID", $terminalId);
writeHiddenField("CURRENCY", $currency);
writeHiddenField("ORDERID", $orderId);
writeHiddenField("AMOUNT", $amount);
# writeHiddenField("PHONE", $phone);
writeHiddenField("EMAIL", $email);
writeHiddenField("DATETIME", $dateTime);
if(isset($cardholderName) && $cardholderName != '') writeHiddenField("CARDHOLDERNAME", $cardholderName);
if(isset($postcode) && $postcode != '') {
	writeHiddenField("ADDRESS1", $address1);
	writeHiddenField("ADDERSS2", $address2);
	writeHiddenField("POSTCODE", $postcode);
}
if(isset($email) && $email != '') writeHiddenField("EMAIL", $email);
if(isset($description) && $description != '') writeHiddenField("DESCRIPTION", $description);
if(isset($autoReady) && $autoReady != '') writeHiddenField("AUTOREADY", $autoReady);
writeHiddenField("RECEIPTPAGEURL", $receiptPageURL);
if($validationURL != '') writeHiddenField("VALIDATIONURL", $validationURL);
writeHiddenField("HASH", $requestHash);

# You can also include any other custom fields here. Their contents will for included in the response POST to the receipt page.
# writeHiddenField("Customer ID", '32856951');

# Write the JavaScript that will submit the form to WorldNet.
echo '</form>Submitting order to WorldNet for Payment...<script language="JavaScript">document.getElementById("worldnetform").submit();</script></body></html>';

?>