<?php

class Gateway {
	private $_config;
	private $_module;
	private $_basket;

	public function __construct($module = false, $basket = false) {
		$this->_module	= $module;
		$this->_basket =& $GLOBALS['cart']->basket;
                $this->_url = 'https://';
				if($this->_module['testMode'] =='Y') $this->_url .= 'test';
				switch (strtolower($this->_module['gateway'])) {
					default :
					case 'worldnet'  : $this->_url .= 'payments.worldnettps.com'; break;
					case 'cashflows' : $this->_url .= 'cashflows.worldnettps.com'; break;
					case 'payius'    : $this->_url .= 'payments.payius.com' ; break;
					case 'pagotechnology'    : $this->_url .= 'payments.pagotechnology.com' ; break;
					case 'globalonepay'    : $this->_url .= 'payments.globalone.me' ; break;
					case 'anywherecommerce'    : $this->_url .= 'payments.anywherecommerce.com' ; break;
					case 'ctpayment'    : $this->_url .= 'payments.ct-payment.com' ; break;
					case 'payzone'    : $this->_url .= 'payment.payzone.ie' ; break;
					case 'payconex'    : $this->_url .= 'gateway.payconex.net' ; break;
				}
          	$this->_url .= '/merchant/paymentpage';               
                     
               }

	##################################################

	function transfer() {
                 
		$transfer	= array(
			'action'	=> $this->_url,
			'method'	=> 'post',
			'target'	=> '_self',
			'submit'	=> 'auto',
		);
		return $transfer;
	}

	function repeatVariables() {
		return false;
	}

	function fixedVariables() {
                 global $description;
		
		$timestamp 	= strftime("%H%M%S");
 		$terminalid = $this->_module['merchant_id'];
	 	$secret = $this->_module['shared_secret'];
                
		$cart_id = $this->_basket['cart_order_id'];
		$currency = $GLOBALS['config']->get('config', 'default_currency');
                $wncurrency = $this->_module['currency'];  
                if($currency!=$wncurrency) 
	        die("ERROR: Cart Currency not configured for WorldNet Payment plug-in. Transaction not processed. Please contact site administrator.");
		
		$dateTime = date('d-m-Y:H:i:s:000');
		$orderid = 'ID'.rand(0,100).'-'.substr($this->_basket['cart_order_id'],14);
                $email = $this->_basket['billing_address']['email'];
                $receiptPageURL = $GLOBALS['storeURL']."/index.php?_g=rm&type=gateway&cmd=process&module=WorldnetHPP&cartid=".$cart_id;
                $amount 	= $this->_basket['total'];
		$description = $this->_module['currency'];                  
		$requestHash = md5($terminalid.$orderid.$amount.$dateTime.$receiptPageURL.$secret);
		$this->_module['testmode'];
		$hiddenVars = array(			
			'TERMINALID' 	=> $terminalid,
                        'CURRENCY' 	=> $currency,
			'AMOUNT' 	=> $amount,
                        'ORDERID' 	=> $orderid,			
			'DESCRIPTION'    => $this->_module['send_email'],
                        'DATETIME' 	=> $dateTime,
                        'HASH'          => $requestHash,
                        'RECEIPTPAGEURL' => $receiptPageURL
			
		);
		
               if($this->_module['send_email']=='Y')                         
                  		  $hiddenVars['EMAIL'] = $email;   
                         return $hiddenVars;

	}
	 
		

	 function call() {
		
		return false;
	}

	 function process() {
		
		$GLOBALS['storeURL'] = str_replace('/modules/gateway/WorldnetHPP','',$GLOBALS['storeURL']);
		$order		     = Order::getInstance();
		$cart_order_id	     = $_GET['cartid'];
		$order_summary	     = $order->getSummary($cart_order_id);
		$responseOrder       = $_GET['ORDERID'];
		
		$terminalid          = $this->_module['merchant_id'];
	 	$secret              = $this->_module['shared_secret'];
		
		$amount              = $_GET['AMOUNT'];
		$dateTime            = $_GET['DATETIME'];
		$authCode            = $_GET['APPROVALCODE'];
                $responseHash        = $_GET['HASH'];
		$responseCode        = $_GET['RESPONSECODE'];
		$responseText        = $_GET['RESPONSETEXT'];
                $uniqueref           = $_GET['UNIQUEREF'];

                $hash = md5($terminalid.$responseOrder.$amount.$dateTime.$responseCode.$responseText.$secret);


		if ($hash == $responseHash && $responseCode == "A") {
			
			$order->orderStatus(Order::ORDER_PROCESS, $cart_order_id);
			$order->paymentStatus(Order::PAYMENT_SUCCESS, $cart_order_id);
	
                        $paymentResult = 2;
			$status = 'Success';
			$smarty_data = array(
				'message' 	 	=> "Card charged successfully for cart ID: ".$cart_order_id.".",
				'redirect_text' 	=> 'Return to Store',
				'return_url' 		=> $GLOBALS['storeURL'].'/index.php?_a=complete'
			);
		} else {
			$status = 'Fail';
                        $paymentResult = 1;
                        if ($hash != $responseHash) {
				$order->orderStatus(6,$cart_order_id);
				$smarty_data = array(
					'message' 	 	=> 'Response Hash was incorrect.'.$hash.'datwe'.$amount,
					'redirect_text' 	=> 'Try Again',
					'return_url' 		=> $GLOBALS['storeURL'].'/index.php?_a=gateway'
					);	
		     	}
                        elseif ($responseCode != "A") {
				$order->orderStatus(4,$cart_order_id);
				$smarty_data = array(
					'message' 		=> "Transaction was not approved. Message from bank: ".$responseText.".",
					'redirect_text' 	=> 'Try Again',
					'return_url' 		=> $GLOBALS['storeURL'].'/index.php?_a=gateway'
					);	
			} else {
				$order->orderStatus(6,$cart_order_id);
				$smarty_data = array(
					'message' 		=> "Payment failed.",
					'redirect_text' 	=> 'Try Again',
					'return_url' 		=> $GLOBALS['storeURL'].'/index.php?_a=gateway'
					);
	}
			
		}
		
		$transData['notes']		= $_POST['MESSAGE'];
		$transData['gateway']		= 'WorldnetHPP';
		$transData['order_id']		= $cart_order_id;
		$transData['trans_id']		= $_POST['AUTHCODE'];
		$transData['amount']		= $_POST['AMOUNT'];
		$transData['status']		= $status;
		$transData['customer_id']	= $order_summary['customer_id'];
		$transData['extra']			= '';
		
		$order->logTransaction($transData);
		
		unset($GLOBALS['seo']);
		
		
		$GLOBALS['smarty']->assign("DATA", $smarty_data);
						
		## Check for custom template for module in skin folder
		$file_name = 'confirm.tpl';
		$form_file = $GLOBALS['gui']->getCustomModuleSkin('gateway', dirname(__FILE__), $file_name);
		$GLOBALS['gui']->changeTemplateDir($form_file);
		$ret = $GLOBALS['smarty']->fetch($file_name);
		$GLOBALS['gui']->changeTemplateDir();
		die($ret);	
	}

	 function form() {
		return false;
	}
}
