<?php

	class CHECKOUT_WORLDNETHPP extends ISC_CHECKOUT_PROVIDER
	{
		private $_testmode = "";
		private $_terminalid= "";
		private $_sharedsecret = "";
		private $_currency = "";
		private $_sendhostemail = "";

		/*
			Checkout class constructor
		*/
		public function __construct()
		{
			parent::__construct();
			$this->_languagePrefix = "WorldNet";
			$this->_name = GetLang($this->_languagePrefix."Name");
			$this->_image = "worldnethpp_logo.gif";
			$this->_description = GetLang($this->_languagePrefix."Desc");
			$this->_help = sprintf(GetLang($this->_languagePrefix."Help"), $GLOBALS['ShopPathSSL']);
		}

		/*
			Checkout settings
		*/
		public function SetCustomVars()
		{
			$this->_variables['gateway'] = array("name" => GetLang($this->_languagePrefix."Gateway"),
			   "type" => "dropdown",
			   "help" => GetLang($this->_languagePrefix."GateWayHelp"),
			   "default" => "payments",
			   "required" => true,
			   "options" => array(GetLang($this->_languagePrefix."GatewayWorldNet") => "payments",
					GetLang($this->_languagePrefix."GatewayCashFlows") => "cashflows"
				),
				"multiselect" => false
			);

			$this->_variables['testmode'] = array("name" => GetLang($this->_languagePrefix."TestMode"),
			   "type" => "dropdown",
			   "help" => GetLang($this->_languagePrefix."TestModeHelp"),
			   "default" => "YES",
			   "required" => true,
			   "options" => array(GetLang($this->_languagePrefix."TestModeNo") => "NO",
							  GetLang($this->_languagePrefix."TestModeYes") => "YES"
				),
				"multiselect" => false
			);

			$this->_variables['displayname'] = array("name" => GetLang($this->_languagePrefix."DisplayName"),
			   "type" => "textbox",
			   "help" => GetLang($this->_languagePrefix."DisplayNameHelp"),
			   "default" => GetLang($this->_languagePrefix."DisplayNameDefault"),
			   "required" => true
			);

			$this->_variables['terminalid'] = array("name" => GetLang($this->_languagePrefix."TerminalId"),
			   "type" => "textbox",
			   "help" => GetLang($this->_languagePrefix."TerminalIdHelp"),
			   "default" => "",
			   "required" => true
			);

			$this->_variables['currency'] = array("name" => GetLang($this->_languagePrefix."Currency"),
			   "type" => "dropdown",
			   "help" => GetLang($this->_languagePrefix."CurrencyHelp"),
			   "default" => "EUR",
			   "required" => true,
			   "options" => array(GetLang($this->_languagePrefix."Currency1") => "AUD",
							  GetLang($this->_languagePrefix."Currency2") => "GBP",
							  GetLang($this->_languagePrefix."Currency3") => "CAD",
							  GetLang($this->_languagePrefix."Currency4") => "CZK",
							  GetLang($this->_languagePrefix."Currency5") => "DKK",
							  GetLang($this->_languagePrefix."Currency6") => "EUR",
							  GetLang($this->_languagePrefix."Currency7") => "HKD",
							  GetLang($this->_languagePrefix."Currency8") => "HUF",
							  GetLang($this->_languagePrefix."Currency9") => "JPY",
							  GetLang($this->_languagePrefix."Currency10") => "NZD",
							  GetLang($this->_languagePrefix."Currency11") => "NOK",
							  GetLang($this->_languagePrefix."Currency12") => "PLN",
							  GetLang($this->_languagePrefix."Currency13") => "SGD",
							  GetLang($this->_languagePrefix."Currency14") => "SEK",
							  GetLang($this->_languagePrefix."Currency15") => "CHF",
							  GetLang($this->_languagePrefix."Currency16") => "USD",
				),
				"multiselect" => false
			);

			$this->_variables['sharedsecret'] = array("name" => GetLang($this->_languagePrefix."SharedSecret"),
			   "type" => "password",
			   "help" => GetLang($this->_languagePrefix."SharedSecretHelp"),
			   "default" => "",
			   "required" => true
			);

			$this->_variables['sendhostemail'] = array("name" => GetLang($this->_languagePrefix.'SendHostEmail'),
			   "type" => "dropdown",
			   "help" => GetLang($this->_languagePrefix.'SendHostEmailHelp'),
			   "default" => "NO",
			   "required" => true,
			   "options" => array(GetLang($this->_languagePrefix.'SendHostEmailNo') => "NO",
							  GetLang($this->_languagePrefix.'SendHostEmailYes') => "YES"
				),
				"multiselect" => false
			);
		}

		/**
		*	Redirect the customer to WorldNet TPS's Hosted Payment Page to enter their payment details
		*/
		public function TransferToProvider()
		{
			$this->_gateway = $this->GetValue("gateway");
			$this->_testmode = $this->GetValue("testmode");
			$this->_terminalid = $this->GetValue("terminalid");
			$this->_sharedsecret = $this->GetValue("sharedsecret");
			$this->_currency = $this->GetValue("currency");
			$this->_sendhostemail = $this->GetValue("sendhostemail");

			// Load the pending order
			$orderId = $this->GetCombinedOrderId();
			$amount = number_format($this->GetGatewayAmount(),2,'.','');

			if($this->_testmode == "YES") $url = "https://test".$this->_gateway.".worldnettps.com/merchant/paymentpage";
			else $url = "https://".$this->_gateway.".worldnettps.com/merchant/paymentpage";

			$dateTime = date('d-m-Y:H:i:s:000');
			$receiptPageURL = GetConfig('ShopPathSSL') . '/finishorder.php?provider=checkout_worldnethpp';
			$transHash = md5($this->_terminalid.$orderId.$amount.$dateTime.$receiptPageURL.$this->_sharedsecret);

			$hiddenFields = array(
				'TERMINALID' => $this->_terminalid,
				'ORDERID' => $orderId,
				'CURRENCY' => $this->_currency,
				'AMOUNT' => $amount,
				'DATETIME' => $dateTime,
				'RECEIPTPAGEURL' => $receiptPageURL,
				'HASH' => $transHash
			);

			if($this->_sendhostemail == "YES") {
				$billingDetails = $this->GetBillingDetails();
				$email = $billingDetails['ordbillemail'];
				array_push($hiddenFields,'EMAIL',$email);
			}

			$this->RedirectToProvider($url, $hiddenFields);
		}

		/**
		*	Verify the reponse from WorldNet TPS and assign to the 
		*/
		public function VerifyOrder(&$PendingOrder)
		{
			if(isset($_GET['APPROVALCODE']) && isset($_GET['ORDERID']) && isset($_GET['RESPONSECODE']) && isset($_GET['RESPONSETEXT']) && isset($_GET['DATETIME']) && isset($_GET['HASH'])) {
				$respApprovalCode = $_GET['APPROVALCODE'];
				$repsOrderId = $_GET['ORDERID'];
				$respCode = $_GET['RESPONSECODE'];
				$respText = $_GET['RESPONSETEXT'];
				$respDateTime = $_GET['DATETIME'];
				$respHash = $_GET['HASH'];

				$this->_terminalid = $this->GetValue("terminalid");
				$this->_sharedsecret = $this->GetValue("sharedsecret");
				$amount = number_format($this->GetGatewayAmount(),2,'.','');
				
				$expectedRespHash = md5($this->_terminalid.$repsOrderId.$amount.$respDateTime.$respCode.$respText.$this->_sharedsecret);

				if($respHash != $expectedRespHash) {
					$GLOBALS['ISC_CLASS_LOG']->LogSystemError(array('payment', $this->GetName()), sprintf(GetLang($this->_languagePrefix."InvalidHash"), $expectedRespHash, $respHash));
					return false;
				} elseif($respCode == "D" || $respCode == "R") {
					$GLOBALS['ISC_CLASS_LOG']->LogSystemError(array('payment', $this->GetName()), sprintf(GetLang($this->_languagePrefix."Declined"), $respText));
					$PendingOrder['paymentstatus'] = PAYMENT_STATUS_DECLINED;
					return true;
				} elseif($respCode == "A") {
					$GLOBALS['ISC_CLASS_LOG']->LogSystemSuccess(array('payment', $this->GetName()), sprintf(GetLang($this->_languagePrefix."Success"), $respApprovalCode));
					$PendingOrder['paymentstatus'] = PAYMENT_STATUS_PAID;
					return true;
				} else {
					$GLOBALS['ISC_CLASS_LOG']->LogSystemError(array('payment', $this->GetName()), sprintf(GetLang($this->_languagePrefix."UnexpectedResponse"), $respCode, $respText));
					return false;
				}
			}
			else {
				$GLOBALS['ISC_CLASS_LOG']->LogSystemError(array('payment', $this->GetName()), GetLang($this->_languagePrefix."ErrorInvalid"));
				return false;
			}
		}
	}
