<?php
/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace WorldnetPayments\Payment\Model\Source;

use Magento\Framework\Option\ArrayInterface;

/**
 *
 * Gateway Payment Action Dropdown source
 */
class CurrencyAction implements ArrayInterface
{
    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        return [
            [
                'value' => \WorldnetPayments\Payment\Model\WorldnetPayments::CURRENCY_EUR,
                'label' => __('Euro')
            ],
            [
                'value' => \WorldnetPayments\Payment\Model\WorldnetPayments::CURRENCY_GBP,
                'label' => __('Sterling')
            ],
            [
                'value' => \WorldnetPayments\Payment\Model\WorldnetPayments::CURRENCY_USD,
                'label' => __('US Dollar')
            ],
            [
                'value' => \WorldnetPayments\Payment\Model\WorldnetPayments::CURRENCY_CAD,
                'label' => __('Canadian Dollar')
            ],
            [
                'value' => \WorldnetPayments\Payment\Model\WorldnetPayments::CURRENCY_AUD,
                'label' => __('Australian Dollar')
            ],
            [
                'value' => \WorldnetPayments\Payment\Model\WorldnetPayments::CURRENCY_DKK,
                'label' => __('Danish Krone')
            ],
            [
                'value' => \WorldnetPayments\Payment\Model\WorldnetPayments::CURRENCY_SEK,
                'label' => __('Swedish Krona')
            ],
            [
                'value' => \WorldnetPayments\Payment\Model\WorldnetPayments::CURRENCY_NOK,
                'label' => __('Norwegian Krone')
            ]
        ];
    }
}
