<?php
/*
  $
*/

class worldnet
{
  var $code, $title, $description, $enabled;
  var $oid;

  function worldnet()
  {
    global $order;

    $this->code        = 'worldnet';
    $this->title       = MODULE_PAYMENT_WORLDNET_TEXT_TITLE;
    $this->description = MODULE_PAYMENT_WORLDNET_TEXT_DESCRIPTION;
    $this->sort_order  = MODULE_PAYMENT_WORLDNET_SORT_ORDER;
    $this->enabled     = ((MODULE_PAYMENT_WORLDNET_STATUS == 'True') ? true : false);

    if( (int)MODULE_PAYMENT_WORLDNET_ORDER_STATUS_ID > 0 )
    {
      $this->order_status = MODULE_PAYMENT_WORLDNET_ORDER_STATUS_ID;
    }

    if(is_object($order))
      $this->update_status();

    //$this->form_action_url = MODULE_PAYMENT_WORLDNET_URL;
  }

  // class methods
  function update_status()
  {
    global $order;

    if( ($this->enabled == true) && ((int)MODULE_PAYMENT_WORLDNET_ZONE > 0) )
    {
      $check_flag = false;
      $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_WORLDNET_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
      while ($check = tep_db_fetch_array($check_query))
      {
        if ($check['zone_id'] < 1)
        {
          $check_flag = true;
          break;
        } 
        elseif ($check['zone_id'] == $order->billing['zone_id'])
        {
          $check_flag = true;
          break;
        }
      }

      if($check_flag == false)
      {
        $this->enabled = false;
      }
    }
  }

  function javascript_validation()
  {
    return false;
  }

  function selection()
  {
    return array( 'id'     => $this->code,
                  'module' => $this->title );
  }

  function pre_confirmation_check()
  {
    return false;
  }

  function confirmation()
  {
      global $order;

      for ($i=1; $i<13; $i++) {
        $expires_month[] = array('id' => sprintf('%02d', $i), 'text' => strftime('%B',mktime(0,0,0,$i,1,2000)));
      }

      $today = getdate(); 
      for ($i=$today['year']; $i < $today['year']+10; $i++) {
        $expires_year[] = array('id' => strftime('%y',mktime(0,0,0,1,1,$i)), 'text' => strftime('%y',mktime(0,0,0,1,1,$i)));
      }

	  $card_types[] = array('id' => 'VISA', 'text' => 'Visa');
	  $card_types[] = array('id' => 'MASTERCARD', 'text' => 'MasterCard');
	  $card_types[] = array('id' => 'LASER', 'text' => 'Laser');
	  $card_types[] = array('id' => 'ELECTRON', 'text' => 'Electron');
	  $card_types[] = array('id' => 'DELTA', 'text' => 'Visa Debit');
	  $card_types[] = array('id' => 'MAESTRO', 'text' => 'Maestro');

      $confirmation = array('fields' => array(array('title' => MODULE_PAYMENT_WORLDNET_CREDIT_CARD_OWNER,
                                                    'field' => tep_draw_input_field('cc_owner', $order->billing['firstname'] . ' ' . $order->billing['lastname'])),
                                              array('title' => MODULE_PAYMENT_WORLDNET_CREDIT_CARD_TYPE,
                                                    'field' => tep_draw_pull_down_menu('cc_type', $card_types)),
                                              array('title' => MODULE_PAYMENT_WORLDNET_CREDIT_CARD_NUMBER,
                                                    'field' => tep_draw_input_field('cc_number_nh-dns','',' autocomplete="off"')),
                                              array('title' => MODULE_PAYMENT_WORLDNET_CREDIT_CARD_EXPIRES,
                                                    'field' => tep_draw_pull_down_menu('cc_expires_month', $expires_month) . '&nbsp;' . tep_draw_pull_down_menu('cc_expires_year', $expires_year)),
                                              array('title' => MODULE_PAYMENT_WORLDNET_CREDIT_CARD_CVC,
                                                    'field' => tep_draw_input_field('cc_cvc_nh-dns', '', 'size="5" maxlength="4" autocomplete="off"'))));

      return $confirmation;
  }

  function process_button()
  {
		  return false;
  }

  function before_process()
  {
    global $HTTP_POST_VARS, $osC_Session, $order, $currencies,$currency;

    if ($currency == MODULE_PAYMENT_WORLDNET_CURRENCY_2) {
	$my_currency = MODULE_PAYMENT_WORLDNET_CURRENCY_2;
        $terminalid = MODULE_PAYMENT_WORLDNET_ID_2;
        $secret = MODULE_PAYMENT_WORLDNETHPP_SECRET_2;
    } else {
        $my_currency = MODULE_PAYMENT_WORLDNET_CURRENCY;
        $terminalid = MODULE_PAYMENT_WORLDNET_ID;
        $secret = MODULE_PAYMENT_WORLDNETHPP_SECRET;
    }
    	$gateway = MODULE_PAYMENT_WORLDNETHPP_GATEWAY;
    	$curr = $my_currency;
    	$amount = number_format($order->info['total'] * $currencies->get_value($my_currency), $currencies->get_decimal_places($my_currency),'.','');
	$seconds = (date('H') * 3600) + (date('i') * 60) + date('s');
	$orderid = date('zy') . $seconds;
	$description = substr(STORE_NAME, 0, 255);
	$email = substr($order->customer['email_address'], 0, 255);

	$cardType = $HTTP_POST_VARS['cc_type'];
	$cardNumber = substr($HTTP_POST_VARS['cc_number_nh-dns'], 0, 22);
	$expiry = $HTTP_POST_VARS['cc_expires_month'] . $HTTP_POST_VARS['cc_expires_year'];
	$cardHolderName = $HTTP_POST_VARS['cc_owner'];

	$testMode = (MODULE_PAYMENT_WORLDNET_TEST_MODE=="True" ? true : false);

	//Process transaction
	require_once('WorldNetTPS/worldnet_tps_xml.php');

	$sale = new XmlAuthRequest($terminalid,$orderid,$my_currency,$amount,$cardNumber,$cardType);
	$sale->SetEmail($email);
	$sale->SetDescription($description);
	if($cardType != "SECURECARD") $sale->SetNonSecureCardCardInfo($expiry,$cardHolderName);
	if($cvv != "") $sale->SetCvv($cvv);
//	if($address1 != "" && $address2 != "" && $postcode != "") $sale->SetAvs($address1,$address2,$postcode);
//	if($cardCurrency != "" && $cardAmount != "" && $conversionRate != "") $sale->SetForeignCurrencyInformation($cardCurrency,$cardAmount,$conversionRate);
//	if($avsonly) $sale->SetAvsOnly("Y");
//	if($autoready) $sale->SetAutoReady("Y");
//	if($mpiref != "") $sale->SetMpiRef($mpiref);
	$response = $sale->ProcessRequest($secret,$testMode,$gateway);

	// Generate expected response hash
	$hashtype = MODULE_PAYMENT_WORLDNET_PROCESSING_HASH_TYPE;
    if ($hashtype == 'New') {
        $responseHash = md5($terminalid . $response->UniqueRef() . $amount . $response->DateTime() . $response->ResponseCode() . $response->ResponseText() . $secret);
    } else {
        $responseHash = md5($terminalid . $response->UniqueRef() . $amount . $response->DateTime() . $response->ResponseCode() . $response->ResponseText() . $secret);
    }

	// Check Response
	if($response->IsError()) {
		tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=' . $this->code . '&error=' . preg_replace('/"/i','\'',$response->ErrorString()), 'SSL'));
	} elseif($responseHash != $response->Hash()) {
		tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=' . $this->code . '&error=' . TEXT_WORLDNET_HASH_ERROR, 'SSL'));
    } elseif($response->ResponseCode() != "A") {
		tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=' . $this->code . '&error=Bank Response: ' . $response->responseText(), 'SSL'));
    }
  }

  function after_process()
  {
    return false;
  }

  function get_error()
  {
    if (PHP_VERSION < 4.1)
    {
      global $_GET;
    }

    $error = array('title' => WORLDNET_ERROR_TITLE,
                   'error' => ((isset($_GET['error'])) ? stripslashes(urldecode($_GET['error'])) : IPAYMENT_ERROR_MESSAGE));

    return $error;
  }

  function output_error()
  {
    return false;
  }

  function check()
  {
    if(!isset($this->_check))
    {
      $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_WORLDNET_STATUS'");
      $this->_check = tep_db_num_rows($check_query);
    }
    return $this->_check;
  }

  function install()
  {
    tep_db_query(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES 
      (
        'Enable WorldNet TPS Module', 
        'MODULE_PAYMENT_WORLDNET_STATUS', 
        'True', 
        'Do you want to accept WorldNet TPS payments?', 
        '6', 
        '1', 
        'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

      tep_db_query(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES 
      (
        'Gateway', 
        'MODULE_PAYMENT_WORLDNETHPP_GATEWAY', 
        'WorldNet', 
        'Under which WorldNet gateway is your account?', 
        '6', 
        '2', 
        'tep_cfg_select_option(array(\'WorldNet\', \'CashFlows\',\'Payius\',\'Pago Technology\',\'GlobalOnePay\',\'AnywhereCommerce\',\'CT Payments\',\'PayConex Plus\',\'Payzone\'), ', now())");

  
    tep_db_query(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES 
      (
        'Test Mode', 
        'MODULE_PAYMENT_WORLDNET_TEST_MODE', 
        'Test Mode',
        'Are you testing into WorldNet TPS?', 
        '6', 
        '3', 
        'tep_cfg_select_option(array(\'True\',\'False\'), ', now())");
        
    tep_db_query(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'First Transaction Currency',
        'MODULE_PAYMENT_WORLDNET_CURRENCY',
        'Selected Currency',
        'The first currency to use for credit card transactions',
        '6',
        '4',
        'tep_cfg_select_option(array(\'EUR\',\'GBP\',\'USD\',\'AUD\',\'CAD\',\'SEK\',\'DKK\',\'NOK\'), ', now())");

    tep_db_query(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES
      (
        'First Terminal ID',
        'MODULE_PAYMENT_WORLDNET_ID',
        'TerminalID 1',
        'The Terminal ID provided by WorldNet TPS for the first currency',
        '6',
        '5',
        now())");

    tep_db_query(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES 
      (
        'First Shared Secret', 
        'MODULE_PAYMENT_WORLDNETHPP_SECRET', 
        'Secret', 
        'The Shared Secret provided by WorldNet TPS for the first currency',
        '6', 
        '6',
        now())"); 
     
    tep_db_query(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Second Transaction Currency (if applicable)',
        'MODULE_PAYMENT_WORLDNET_CURRENCY_2',
        'Selected Currency',
        'The second currency to use for credit card transactions',
        '6',
        '7',
        'tep_cfg_select_option(array(\'EUR\',\'GBP\',\'USD\',\'AUD\',\'CAD\',\'SEK\',\'DKK\',\'NOK\'), ', now())");

    tep_db_query(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES
      (
        'Second Terminal ID',
        'MODULE_PAYMENT_WORLDNET_ID_2',
        'TerminalID 2',
        'The Terminal ID provided by WorldNet TPS for the second currency',
        '6',
        '8',
        now())");

    tep_db_query(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES 
      (
        'Second Shared Secret', 
        'MODULE_PAYMENT_WORLDNETHPP_SECRET_2', 
        'Secret', 
        'The Shared Secret provided by WorldNet TPS.',
        '6', 
        '9',
        now())");

    tep_db_query(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Hash type',
        'MODULE_PAYMENT_WORLDNET_PROCESSING_HASH_TYPE',
        'New',
        'Set the hash type used to validate the payment (New unless otherwise instructed by WorldNet TPS)',
        '6',
        '10',
        'tep_cfg_select_option(array(\'New\',\'Old\'), ', now())");

tep_db_query(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES 
      (
        'Sort order of display.', 
        'MODULE_PAYMENT_WORLDNET_SORT_ORDER', 
        '0', 
        'Sort order of display. Lowest is displayed first.', 
        '6', 
        '11',
        now())");
  
    tep_db_query(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added)
      VALUES
      (
        'Set Order Status',
        'MODULE_PAYMENT_WORLDNET_ORDER_STATUS_ID',
        '0',
        'Set the status of orders made with this payment module to this value',
        '6',
        '12',
        'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");
  }

  function remove()
  {
    tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key like 'MODULE_PAYMENT_WORLDNET%';");
  }

  function keys()
  {
    return array(
      'MODULE_PAYMENT_WORLDNET_STATUS'              ,
      'MODULE_PAYMENT_WORLDNETHPP_GATEWAY'          ,
      'MODULE_PAYMENT_WORLDNET_TEST_MODE'           ,
      'MODULE_PAYMENT_WORLDNET_CURRENCY'            ,
      'MODULE_PAYMENT_WORLDNET_ID'                  ,
      'MODULE_PAYMENT_WORLDNETHPP_SECRET'           ,
      'MODULE_PAYMENT_WORLDNET_CURRENCY_2'          ,
      'MODULE_PAYMENT_WORLDNET_ID_2'                ,
      'MODULE_PAYMENT_WORLDNETHPP_SECRET_2'               ,
      'MODULE_PAYMENT_WORLDNET_PROCESSING_HASH_TYPE',
      'MODULE_PAYMENT_WORLDNET_ORDER_STATUS_ID'     ,
      'MODULE_PAYMENT_WORLDNET_SORT_ORDER');
  }
}

?>
