<?php
/*
* 2007-2011 PrestaShop 
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2011 PrestaShop SA
*  @version  Release: $Revision: 7732 $
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

include(dirname(__FILE__).'/../../config/config.inc.php');
include(dirname(__FILE__).'/worldnethpp.php');

$paymentClass = new WorldNetHPP();

/* First we need to check var presence */
$neededVars = array('TERMINALID', 'ORDERID', 'AMOUNT', 'PRESTASHOPSECUREKEY', 'DATETIME', 'RESPONSECODE', 'RESPONSETEXT', 'UNIQUEREF', 'HASH');
$params = '<br /><br />'.$paymentClass->l('Received parameters:').'<br /><br />';

foreach ($neededVars AS $k) {
	if (!isset($_REQUEST[$k])) die($paymentClass->l('Missing parameter:').' '.$k);
	else $params .= $k.' : '.$_REQUEST[$k].'<br />';
}

/* Then, load the customer cart and perform some checks */
$cart = new Cart((int)($_REQUEST['ORDERID']));
if (Validate::isLoadedObject($cart))
{
	if($_REQUEST['TERMINALID'] == Configuration::get('WORLDNETHPP_TID1')) {
		$paymentCurrency = Configuration::get('WORLDNETHPP_CUR1');
		$sharedSecret = Configuration::get('WORLDNETHPP_SECRET1');
	} else {
		$paymentCurrency = Configuration::get('WORLDNETHPP_CUR2');
		$sharedSecret = Configuration::get('WORLDNETHPP_SECRET2');
	}

	$expectedResponseHash = md5($_REQUEST['TERMINALID'] . $_REQUEST['ORDERID'] . $_REQUEST['AMOUNT'] . $_REQUEST['DATETIME'] . $_REQUEST['RESPONSECODE'] . $_REQUEST['RESPONSETEXT'] . $sharedSecret);
	if ($expectedResponseHash == $_REQUEST['HASH'])
	{
		switch ($_REQUEST['RESPONSECODE'])
		{
			case 'A':
				/* Payment OK */
				$paymentClass->validate((int)$_REQUEST['ORDERID'], Configuration::get('PS_OS_WS_PAYMENT'), (float)($_REQUEST['AMOUNT']), $paymentClass->l('Payment Successfully Authorised. Unique Reference: ').$_REQUEST['UNIQUEREF'], $_REQUEST['PRESTASHOPSECUREKEY']);
				echo "OK";
				break;
			default:
				$paymentClass->validate((int)$_REQUEST['ORDERID'], Configuration::get('PS_OS_ERROR'), 0, $paymentClass->l('Payment Not Authorised! Response: ').$_REQUEST['RESPONSETEXT'], $_REQUEST['PRESTASHOPSECUREKEY']);
				echo "OK";
		}
		exit;
	}
	else
	{
		$message = $paymentClass->l('Response Hash not as expected!').'<br />'.$paymentClass->l('Hash sent: ').' '.$_REQUEST['HASH'].'<br />'.$paymentClass->l('Hash calculated: ').' '.$expectedResponseHash;
		$paymentClass->validate((int)$_REQUEST['orderID'], Configuration::get('PS_OS_ERROR'), 0, $message.'<br />'.$params, $_REQUEST['UNIQUEREF']);
	}
}
