<?php

defined ('_JEXEC') or die('Restricted access');

/**
 *
 * @author Kevin Pattison
 * @version $Id: worldnet.php 2012-08-22
 * @package VirtueMart
 * @subpackage payment
 * @copyright Copyright (C) 2004-2008 soeren - All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See /administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
 *
 * http://virtuemart.org
 */
if (!class_exists ('vmPSPlugin')) {
	require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');
}

class plgVmPaymentWorldnet extends vmPSPlugin {
	public static $_this = FALSE;

	function __construct (& $subject, $config) {
		parent::__construct ($subject, $config);

		$this->_loggable = TRUE;
		$this->tableFields = array_keys($this->getTableSQLFields());
		$this->_tablepkey = 'id';
		$this->_tableId = 'id';
		$varsToPush = $this->getVarsToPush();

		$this->setConfigParameterable ($this->_configTableFieldName, $varsToPush);
	}

	protected function getVmPluginCreateTableSQL () {
		return $this->createTableSQL ('Payment ' . $this->_name . ' Table');
	}

	function getTableSQLFields () {

		$SQLfields = array(
			'id'                                     => 'int(11) UNSIGNED NOT NULL AUTO_INCREMENT',
			'virtuemart_order_id'                    => 'int(1) UNSIGNED',
			'order_number'                           => 'char(64)',
			'virtuemart_paymentmethod_id'            => 'mediumint(1) UNSIGNED',
			'payment_order_total'                    => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\'',
			'payment_currency'                       => 'char(3) '
		);
		return $SQLfields;
	}

	function plgVmConfirmedOrder ($cart, $order) {
		$lang = JFactory::getLanguage ();
		$lang->load ('plg_vmpayment_' . $this->_name, JPATH_ADMINISTRATOR);

		if (!($method = $this->getVmPluginMethod ($order['details']['BT']->virtuemart_paymentmethod_id))) {
			return NULL;
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}

		$sessionID = JFactory::getSession()->getId();

		$q = 'SELECT `currency_code_3` FROM `#__virtuemart_currencies` WHERE `virtuemart_currency_id`="' . $order['details']['BT']->user_currency_id . '" ';
		$db = JFactory::getDBO ();
		$db->setQuery ($q);
		$currency = $db->loadResult ();

		$paymentCurrency = CurrencyDisplay::getInstance ($order['details']['BT']->user_currency_id);
		$amount = round ($paymentCurrency->convertCurrencyTo ($order['details']['BT']->user_currency_id, $order['details']['BT']->order_total, FALSE), 2);
		
		if($order['details']['BT']->user_currency_id == $method->currency1) {
			$terminalId = $method->terminalid1;
			$secret = $method->secret1;
		} elseif($order['details']['BT']->user_currency_id == $method->currency2) {
			$terminalId = $method->terminalid2;
			$secret = $method->secret2;
		} elseif($order['details']['BT']->user_currency_id == $method->currency3) {
			$terminalId = $method->terminalid3;
			$secret = $method->secret3;
		} else die("ERROR: " . $currency . " not configured as a payment currency in the WorldNet HPP plug-in settings!");

		$address = isset($order['details']['ST']) ? $order['details']['ST'] : $order['details']['BT'];
		$state = (isset($address->virtuemart_state_id) ? ShopFunctions::getStateByID($address->virtuemart_state_id) : "");
		$country = ShopFunctions::getCountryByID ($address->virtuemart_country_id, 'country_2_code');

		$dateTime = date('d-m-Y:H:i:s:000');
		
		$receiptURL = JROUTE::_ (JURI::root () . 'index.php?option=com_virtuemart&view=pluginresponse&task=pluginresponsereceived&on=' . $order['details']['BT']->order_number . '&pm=' . $order['details']['BT']->virtuemart_paymentmethod_id . '&Itemid=' . JRequest::getInt ('Itemid'));
		$validationURL = JROUTE::_ (JURI::root () . 'index.php?option=com_virtuemart&view=pluginresponse&task=pluginnotification');
		
		$post_variables = Array(
			"TERMINALID"     => $terminalId,
			"ORDERID"        => $order['details']['BT']->order_number,
			"AMOUNT"         => $amount,
			"CURRENCY"       => $currency,
			"CARDHOLDERNAME" => $address->first_name . " " . $address->last_name,
			"ADDRESS1"       => $address->address_1 . isset($address->address_2) ? ", " . $address->address_2 : "",
			"ADDRESS2"       => $address->city . (($state != "") ? ", " . $state : "") . ", " . $country,
			"POSTCODE"       => $address->zip,
			"COUNTRY"        => $country,
			"DATETIME"       => $dateTime,
			"RECEIPTPAGEURL" => $receiptURL,

			"VALIDATIONURL"  => $validationURL,
			"VMSESSIONID"    => $sessionID,
			"HASH"           => md5($terminalId . $order['details']['BT']->order_number . $amount . $dateTime . $receiptURL . $validationURL . $secret)
		);
		if($method->sendemail) $post_variables["EMAIL"] = $order['details']['BT']->email;

		$dbValues = Array(
			'virtuemart_order_id' => $virtuemart_order_id,
			'order_number' => $order['details']['BT']->order_number,
			'virtuemart_paymentmethod_id' => $cart->virtuemart_paymentmethod_id,
			'payment_order_total' => $amount,
			'payment_currency' => $currency
		);
		$this->storePSPluginInternalData ($dbValues);

		$lang = JFactory::getLanguage();

		$html = '<html><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8"><title>Redirection</title></head><body><form action="' . $this->_getPostUrl($method) . '" method="post" name="vm_worldnet_form" id="vm_worldnet_form" >' . "\n";
		foreach ($post_variables as $name => $value) {
			$html .= '<input type="hidden" name="' . $name . '" value="' . htmlspecialchars ($value) . '" />' . "\n";
		}
		$html .= '</form><script language="JavaScript">document.getElementById("vm_worldnet_form").submit();</script>';
		$html .= JText::sprintf ('VMPAYMENT_WORLDNET_PAYMENT_REDIRECTING');
		$html .= '</body></html>';

		echo $html;

		$cart->_confirmDone = FALSE;
		$cart->_dataValidated = FALSE;
		$cart->setCartIntoSession ();
		die();
	}

	function plgVmOnPaymentResponseReceived (&$html) {

		if (!class_exists ('VirtueMartCart')) {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
		}
		if (!class_exists ('shopFunctionsF')) {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');
		}
		if (!class_exists ('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}

		$virtuemart_paymentmethod_id = JRequest::getInt ('pm', 0);
		$order_number = JRequest::getString ('on', 0);

		if (!($method = $this->getVmPluginMethod ($virtuemart_paymentmethod_id))) {
			return NULL;
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return NULL;
		}

		if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber ($order_number))) {
			return NULL;
		}
		if (!($order = VirtueMartModelOrders::getOrder($virtuemart_order_id))) {
			return NULL;
		}

		$lang = JFactory::getLanguage();

		switch($order['details']['BT']->order_status) {
			case $method->approved_status :
				$html = JText::sprintf ('VMPAYMENT_WORLDNET_STATUS_SUCCESS_CUSTOMER');
				$cart = VirtueMartCart::getCart ();
				$cart->emptyCart();
				return TRUE;
				break;
			case $method->error_status :
				$html = JText::sprintf ('VMPAYMENT_WORLDNET_STATUS_FAILED_CUSTOMER');
				$cart = VirtueMartCart::getCart ();
				$this->processConfirmedOrderPaymentResponse (FALSE, $cart, $order, $html);
				$cart->emptyCart();
				return FALSE;
				break;
			default :
				$html = JText::sprintf ('VMPAYMENT_WORLDNET_STATUS_DECLINED_CUSTOMER');
				$cart = VirtueMartCart::getCart ();
				$this->processConfirmedOrderPaymentResponse (FALSE, $cart, $order, $html);
				return FALSE;
		}
	}

	function plgVmOnPaymentNotification () {
		if (!class_exists ('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}
		$response_data = JRequest::get ('request');
		if (!isset($response_data['ORDERID'])) {
			die("No ORDERID parameter in valudation request!");
		}
		if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($response_data['ORDERID']))) {
			die("Cannot retieve Virtuemart Order! WorldNet Order ID: " . $response_data['ORDERID']);
		}

		$vendorId = 0;
		if (!($payment = $this->getDataByOrderId($virtuemart_order_id))) {
			die("Cannot retieve Virtuemart Order Data! VirtueMart Order ID: " . $virtuemart_order_id);
		}

		$method = $this->getVmPluginMethod($payment->virtuemart_paymentmethod_id);
		if (!$this->selectedThisElement($method->payment_element)) {
			return FALSE;
		}

		if($response_data['TERMINALID'] == $method->terminalid1) {
			$currency = $method->currency1;
			$secret = $method->secret1;
		} elseif($response_data['TERMINALID'] == $method->terminalid2) {
			$currency = $method->currency2;
			$secret = $method->secret2;
		} elseif($response_data['TERMINALID'] == $method->terminalid3) {
			$currency = $method->currency3;
			$secret = $method->secret3;
		} else die("TERMINAL ID NOT RECOGNISED");

		$expectedHash = md5($response_data['TERMINALID'] . $response_data['ORDERID'] . $response_data['AMOUNT'] . $response_data['DATETIME'] . $response_data['RESPONSECODE'] . $response_data['RESPONSETEXT'] . $secret);

		$lang = JFactory::getLanguage();
		$modelOrder = VmModel::getModel('orders');
		$order = array();

		if ($expectedHash != $response_data['HASH']) {
			$order['customer_notified'] = 0;
			$order['order_status'] = $method->error_status;
			$order['comments'] = JText::sprintf ('VMPAYMENT_WORLDNET_STATUS_FAILED_ORDERDETAIL', $expectedHash, $response_data['HASH']);
			die("RESPONSE HASH VALIDATION FAILED!");
		} elseif ($response_data['RESPONSECODE'] == "A") {
			$order['customer_notified'] = 1;
			$order['order_status'] = $method->approved_status;
			$order['comments'] = JText::sprintf ('VMPAYMENT_WORLDNET_STATUS_SUCCESS_ORDERDETAIL', $response_data['APPROVALCODE']);
			$this->emptyCart ($response_data['VMSESSIONID'], $order_number);
		} else {
			$order['customer_notified'] = 0;
			$order['order_status'] = $method->declined_status;
			$order['comments'] = JText::sprintf ('VMPAYMENT_WORLDNET_STATUS_DECLINED_ORDERDETAIL', $response_data['RESPONSETEXT']);
		}

		$this->logInfo ('plgVmOnPaymentNotification return new_status:' . $order['order_status'], 'message');

		$modelOrder->updateStatusForOneOrder ($virtuemart_order_id, $order, TRUE);

		die("OK");
	}

	function plgVmOnShowOrderBEPayment ($virtuemart_order_id, $payment_method_id) {
		if (!$this->selectedThisByMethodId ($payment_method_id)) {
			return NULL;
		}
		if (!($paymentTable = $this->getDataByOrderId ($virtuemart_order_id))) {
			return NULL;
		}

		$html = '<table class="adminlist">' . "\n";
		$html .= $this->getHtmlHeaderBE ();
		$html .= $this->getHtmlRowBE (strtoupper ($this->_name) . '_PAYMENT_NAME', $paymentTable->payment_name);
		foreach ($paymentTable as $key => $value) {
			if (substr ($key, 0, strlen ($code)) == $code) {
				$html .= $this->getHtmlRowBE ($key, $value);
			}
		}
		$html .= "</table>\n";

		return $html;
	}

	function _getPostUrl ($method) {
		$url = "https://" . ($method->testmode == "1" ? "test" : "") . $method->gateway . "/merchant/paymentpage" ;
		return $url;
	}

	/**
	 * Check if the payment conditions are fulfilled for this payment method
	 *
	 * @author: Valerie Isaksen
	 *
	 * @param $cart_prices: cart prices
	 * @param $payment
	 * @return true: if the conditions are fulfilled, false otherwise
	 *
	 */
	protected function checkConditions ($cart, $method, $cart_prices) {
		return TRUE;
	}

	/**
	 * We must reimplement this triggers for joomla 1.7
	 */

	/**
	 * Create the table for this plugin if it does not yet exist.
	 * This functions checks if the called plugin is active one.
	 * When yes it is calling the standard method to create the tables
	 *
	 * @author Valérie Isaksen
	 *
	 */
	function plgVmOnStoreInstallPaymentPluginTable ($jplugin_id) {

		return $this->onStoreInstallPluginTable ($jplugin_id);
	}

	/**
	 * This event is fired after the payment method has been selected. It can be used to store
	 * additional payment info in the cart.
	 *
	 * @author Max Milbers
	 * @author Valérie isaksen
	 *
	 * @param VirtueMartCart $cart: the actual cart
	 * @return null if the payment was not selected, true if the data is valid, error message if the data is not vlaid
	 *
	 */
	public function plgVmOnSelectCheckPayment (VirtueMartCart $cart,  &$msg) {

		return $this->OnSelectCheck ($cart);
	}

	/**
	 * plgVmDisplayListFEPayment
	 * This event is fired to display the pluginmethods in the cart (edit shipment/payment) for exampel
	 *
	 * @param object  $cart Cart object
	 * @param integer $selected ID of the method selected
	 * @return boolean True on succes, false on failures, null when this plugin was not selected.
	 * On errors, JError::raiseWarning (or JError::raiseError) must be used to set a message.
	 *
	 * @author Valerie Isaksen
	 * @author Max Milbers
	 */
	public function plgVmDisplayListFEPayment (VirtueMartCart $cart, $selected = 0, &$htmlIn) {

		return $this->displayListFE ($cart, $selected, $htmlIn);
	}

	/*
		 * plgVmonSelectedCalculatePricePayment
		 * Calculate the price (value, tax_id) of the selected method
		 * It is called by the calculator
		 * This function does NOT to be reimplemented. If not reimplemented, then the default values from this function are taken.
		 * @author Valerie Isaksen
		 * @cart: VirtueMartCart the current cart
		 * @cart_prices: array the new cart prices
		 * @return null if the method was not selected, false if the shiiping rate is not valid any more, true otherwise
		 *
		 *
		 */

	/**
	 * @param VirtueMartCart $cart
	 * @param array          $cart_prices
	 * @param                $cart_prices_name
	 * @return bool|null
	 */
	public function plgVmonSelectedCalculatePricePayment (VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name) {

		return $this->onSelectedCalculatePrice ($cart, $cart_prices, $cart_prices_name);
	}

	/**
	 * plgVmOnCheckAutomaticSelectedPayment
	 * Checks how many plugins are available. If only one, the user will not have the choice. Enter edit_xxx page
	 * The plugin must check first if it is the correct type
	 *
	 * @author Valerie Isaksen
	 * @param VirtueMartCart cart: the cart object
	 * @return null if no plugin was found, 0 if more then one plugin was found,  virtuemart_xxx_id if only one plugin is found
	 *
	 */
	function plgVmOnCheckAutomaticSelectedPayment (VirtueMartCart $cart, array $cart_prices = array(), &$paymentCounter) {

		return $this->onCheckAutomaticSelected ($cart, $cart_prices, $paymentCounter);
	}

	/**
	 * This method is fired when showing the order details in the frontend.
	 * It displays the method-specific data.
	 *
	 * @param integer $order_id The order ID
	 * @return mixed Null for methods that aren't active, text (HTML) otherwise
	 * @author Max Milbers
	 * @author Valerie Isaksen
	 */
	public function plgVmOnShowOrderFEPayment ($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name) {

		$this->onShowOrderFE ($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
	}

	/**
	 * This event is fired during the checkout process. It can be used to validate the
	 * method data as entered by the user.
	 *
	 * @return boolean True when the data was valid, false otherwise. If the plugin is not activated, it should return null.
	 * @author Max Milbers

	public function plgVmOnCheckoutCheckDataPayment($psType, VirtueMartCart $cart) {
	return null;
	}
	 */

	/**
	 * This method is fired when showing when priting an Order
	 * It displays the the payment method-specific data.
	 *
	 * @param integer $_virtuemart_order_id The order ID
	 * @param integer $method_id  method used for this order
	 * @return mixed Null when for payment methods that were not selected, text (HTML) otherwise
	 * @author Valerie Isaksen
	 */
	function plgVmonShowOrderPrintPayment ($order_number, $method_id) {

		return $this->onShowOrderPrint ($order_number, $method_id);
	}

	/**
	 * Save updated order data to the method specific table
	 *
	 * @param array $_formData Form data
	 * @return mixed, True on success, false on failures (the rest of the save-process will be
	 * skipped!), or null when this method is not actived.
	 * @author Oscar van Eijk

	public function plgVmOnUpdateOrderPayment(  $_formData) {
	return null;
	}
	 */
	/**
	 * Save updated orderline data to the method specific table
	 *
	 * @param array $_formData Form data
	 * @return mixed, True on success, false on failures (the rest of the save-process will be
	 * skipped!), or null when this method is not actived.
	 * @author Oscar van Eijk

	public function plgVmOnUpdateOrderLine(  $_formData) {
	return null;
	}
	 */
	/**
	 * plgVmOnEditOrderLineBE
	 * This method is fired when editing the order line details in the backend.
	 * It can be used to add line specific package codes
	 *
	 * @param integer $_orderId The order ID
	 * @param integer $_lineId
	 * @return mixed Null for method that aren't active, text (HTML) otherwise
	 * @author Oscar van Eijk

	public function plgVmOnEditOrderLineBE(  $_orderId, $_lineId) {
	return null;
	}
	 */

	/**
	 * This method is fired when showing the order details in the frontend, for every orderline.
	 * It can be used to display line specific package codes, e.g. with a link to external tracking and
	 * tracing systems
	 *
	 * @param integer $_orderId The order ID
	 * @param integer $_lineId
	 * @return mixed Null for method that aren't active, text (HTML) otherwise
	 * @author Oscar van Eijk

	public function plgVmOnShowOrderLineFE(  $_orderId, $_lineId) {
	return null;
	}
	 */
	function plgVmDeclarePluginParamsPayment ($name, $id, &$data) {

		return $this->declarePluginParams ('payment', $name, $id, $data);
	}

	/**
	 * @param $name
	 * @param $id
	 * @param $table
	 * @return bool
	 */
	function plgVmSetOnTablePluginParamsPayment ($name, $id, &$table) {

		return $this->setOnTablePluginParams ($name, $id, $table);
	}

}

// No closing tag
