<?php
if( !defined( '_VALID_MOS' ) && !defined( '_JEXEC' ) ) die( 'Direct Access to '.basename(__FILE__).' is not allowed.' );
/**
* The ps_authorize class, containing the payment processing code
*  for transactions with authorize.net 
*
* @version $Id$
* @package VirtueMart
* @subpackage payment
* @copyright Copyright (C) 2004-2007 soeren - All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* VirtueMart is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See /administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
*
* http://virtuemart.net
*/

class worldnet_tps_xml {

	var $payment_code = "WNTPS";
	var $classname = "worldnet_tps_xml";
    
	/**
    * Show all configuration parameters for this payment method
    * @returns boolean False when the Payment method has no configration
    */
	function show_configuration() {

		global $VM_LANG, $sess;
		$db =& new ps_DB;
		$payment_method_id = vmGet( $_REQUEST, 'payment_method_id', null );
		/** Read current Configuration ***/
		require_once(CLASSPATH . "payment/WorldNetTPS/" . $this->classname . "_lang.php");
		require_once(CLASSPATH . "payment/" . $this->classname . ".cfg.php");
        if(is_readable(CLASSPATH . "payment/WorldNetTPS/".$this->classname . "_api.php")) {
    ?>
      <table>
        <tr>
            <td><strong><?php echo PHPSHOP_ADMIN_CFG_ENABLE_WORLDNETTPS_TESTMODE ?></strong></td>
            <td>
                <select name="WNTPS_TEST_REQUEST" class="inputbox" >
                <option <?php if (WNTPS_TEST_REQUEST == 'TRUE') echo "selected=\"selected\""; ?> value="TRUE"><?php echo $VM_LANG->_('PHPSHOP_ADMIN_CFG_YES') ?></option>
                <option <?php if (WNTPS_TEST_REQUEST == 'FALSE') echo "selected=\"selected\""; ?> value="FALSE"><?php echo $VM_LANG->_('PHPSHOP_ADMIN_CFG_NO') ?></option>
                </select>
            </td>
            <td><?php echo PHPSHOP_ADMIN_CFG_ENABLE_WORLDNETTPS_TESTMODE_EXPLAIN ?>
            </td>
        </tr>
        <tr>
            <td><strong><?php echo PHPSHOP_ADMIN_CFG_WORLDNETTPS_TERMINALID1 ?></strong></td>
            <td>
                <input type="text" name="WNTPS_TERMINALID1" class="inputbox" value="<?php echo WNTPS_TERMINALID1 ?>" />
            </td>
            <td><?php echo PHPSHOP_ADMIN_CFG_WORLDNETTPS_TERMINALID1_EXPLAIN ?>
            </td>
        </tr>
        <tr>
            <td><strong><?php echo PHPSHOP_ADMIN_CFG_WORLDNETTPS_CURRENCY1 ?></strong></td>
            <td>
                <select name="WNTPS_CURRENCY1" class="inputbox" >
                <option <?php if (WNTPS_CURRENCY1 == 'EUR') echo "selected=\"selected\""; ?> value="EUR"><?php echo PHPSHOP_ADMIN_CFG_WORLDNETTPS_EUR ?></option>
                <option <?php if (WNTPS_CURRENCY1 == 'GBP') echo "selected=\"selected\""; ?> value="GBP"><?php echo PHPSHOP_ADMIN_CFG_WORLDNETTPS_GBP ?></option>
                </select>
            </td>
            <td><?php echo PHPSHOP_ADMIN_CFG_WORLDNETTPS_CURRENCY1_EXPLAIN ?>
            </td>
        </tr>
        <tr>
            <td><strong><?php echo PHPSHOP_ADMIN_CFG_WORLDNETTPS_SHARED_SECRET ?></strong></td>
            <td>
                <input type="text" name="WNTPS_SHAREDSECRET" class="inputbox" value="<?php echo WNTPS_SHAREDSECRET ?>" />
            </td>
            <td><?php echo PHPSHOP_ADMIN_CFG_WORLDNETTPS_SHARED_SECRET_EXPLAIN ?>
            </td>
        </tr>
        <tr>
            <td><strong><?php echo PHPSHOP_ADMIN_CFG_ENABLE_WORLDNETTPS_HOST_EMAIL ?></strong></td>
            <td>
                <select name="WNTPS_SEND_HOST_EMAIL" class="inputbox" >
                <option <?php if (WNTPS_SEND_HOST_EMAIL == 'TRUE') echo "selected=\"selected\""; ?> value="TRUE"><?php echo $VM_LANG->_('PHPSHOP_ADMIN_CFG_YES') ?></option>
                <option <?php if (WNTPS_SEND_HOST_EMAIL == 'FALSE') echo "selected=\"selected\""; ?> value="FALSE"><?php echo $VM_LANG->_('PHPSHOP_ADMIN_CFG_NO') ?></option>
                </select>
            </td>
            <td><?php echo PHPSHOP_ADMIN_CFG_ENABLE_WORLDNETTPS_HOST_EMAIL_EXPLAIN ?>
            </td>
        </tr>
    </table>
   <?php
        } else {
             ?>
       <table width="100%"><tr><td align="center"><b>File: <?php echo CLASSPATH . "payment/WorldNetTPS/" . $this->classname . "_xml.php"; ?> is missing!</td></tr></table>
             <?php
        }
   // return false if there's no configuration
   return true;
	}

	function has_configuration() {
		// return false if there's no configuration
		return true;
	}

	/**
	* Returns the "is_writeable" status of the configuration file
	* @param void
	* @returns boolean True when the configuration file is writeable, false when not
	*/
	function configfile_writeable() {
		return is_writeable( CLASSPATH."payment/".$this->classname.".cfg.php" );
	}

	/**
	* Returns the "is_readable" status of the configuration file
	* @param void
	* @returns boolean True when the configuration file is writeable, false when not
	*/
	function configfile_readable() {
		return is_readable( CLASSPATH."payment/".$this->classname.".cfg.php" );
	}
	/**
	* Writes the configuration file for this payment method
	* @param array An array of objects
	* @returns boolean True when writing was successful
	*/
	function write_configuration( &$d ) {

		require_once(CLASSPATH . "payment/WorldNetTPS/" . $this->classname . "_lang.php");
		
		$my_config_array = array("WNTPS_TEST_REQUEST" => $d['WNTPS_TEST_REQUEST'],
		"WNTPS_TERMINALID1" => $d['WNTPS_TERMINALID1'],
		"WNTPS_CURRENCY1" => $d['WNTPS_CURRENCY1'],
		"WNTPS_SHAREDSECRET" => $d['WNTPS_SHAREDSECRET'],
		"WNTPS_SEND_HOST_EMAIL" => $d['WNTPS_SEND_HOST_EMAIL']
		);
		$config = "<?php\n";
		$config .= "if( !defined( '_VALID_MOS' ) && !defined( '_JEXEC' ) ) die( 'Direct Access to '.basename(__FILE__).' is not allowed.' ); \n\n";
		foreach( $my_config_array as $key => $value ) {
			$config .= "define ('$key', '$value');\n";
		}

		$config .= "\n?>";

		if ($fp = fopen(CLASSPATH ."payment/".$this->classname.".cfg.php", "w")) {
			fputs($fp, $config, strlen($config));
			fclose ($fp);
			return true;
		}
		else {
			return false;
		}
	}

	/**************************************************************************
	** name: process_payment()
	** created by: Kevin Pattison
	** description: process transaction with authorize.net
	** parameters: $order_number, the number of the order, we're processing here
	**            $order_total, the total $ of the order
	** returns:
	***************************************************************************/
	function process_payment($order_number, $order_total, &$d) {

		require_once(CLASSPATH . "payment/WorldNetTPS/" . $this->classname . "_lang.php");
		
		global $vendor_mail, $vendor_currency, $VM_LANG, $vmLogger;
		$ps_vendor_id = $_SESSION["ps_vendor_id"];
		$auth = $_SESSION['auth'];
		$ps_checkout = new ps_checkout;

		// Get the Configuration File for authorize.net
		require_once(CLASSPATH ."payment/".$this->classname.".cfg.php");
		// WorldNet TPS PHP XML Gateway API
		require_once(CLASSPATH . "payment/WorldNetTPS/".$this->classname . "_api.php");

		// Get user billing information
		$dbbt = new ps_DB;

		$qt = "SELECT * FROM #__{vm}_user_info WHERE user_id=".$auth["user_id"]." AND address_type='BT'";

		$dbbt->query($qt);
		$dbbt->next_record();
		$user_info_id = $dbbt->f("user_info_id");
		if( $user_info_id != $d["ship_to_info_id"]) {
			// Get user billing information
			$dbst =& new ps_DB;
			$qt = "SELECT * FROM #__{vm}_user_info WHERE user_info_id='".$d["ship_to_info_id"]."' AND address_type='ST'";
			$dbst->query($qt);
			$dbst->next_record();
		}
		else {
			$dbst = $dbbt;
		}

        // Create XML object and set the relevant values
        $sale = new XmlAuthRequest(WNTPS_TERMINALID1,substr($order_number,3,12),WNTPS_CURRENCY1,$order_total,$_SESSION['ccdata']['order_payment_number'],$_SESSION['ccdata']['creditcard_code']);
		if(WNTPS_SEND_HOST_EMAIL == "TRUE") $sale->SetEmail($dbbt->f("user_email"));
		$sale->SetNonSecureCardCardInfo($_SESSION['ccdata']['order_payment_expire_month'] . substr($_SESSION['ccdata']['order_payment_expire_year'],2,4),$_SESSION['ccdata']['order_payment_name']);
        $sale->SetCvv($_SESSION['ccdata']['credit_card_code']);
		unset($_SESSION['ccdata']['credit_card_code']);
        $sale->SetDescription("ViruteMart Unique order number: " . $order_number);

        // Perform the request online
		$response = $sale->ProcessRequest(WNTPS_SHAREDSECRET,(WNTPS_TEST_REQUEST == "TRUE" ? true : false));
        
        // Calculate the verification has value
        $hash=md5(WNTPS_TERMINALID1 . substr($order_number,3,12) . $order_total . $response->DateTime() . $response->ResponseCode() . $response->ResponseText() . WNTPS_SHAREDSECRET);
        
		$vmLogger->debug('Ensuring that the request was processed successfully');
		if( $response->IsError() ) {
			$vmLogger->err($response->ErrorString());
			return false;
		}
		
		$vmLogger->debug('Comparing HASH values: Local=' . $hash . ', Host=' . $response->Hash());
		if( $response->Hash()!=$hash ) {
			$vmLogger->err('Request and response hash do not match.');
            
			return false;
		}

		// Approved - Success!
		if ($response->ResponseCode() == 'A') {
			$d["order_payment_log"] = $VM_LANG->_('PHPSHOP_PAYMENT_TRANSACTION_SUCCESS').": ";
			$d["order_payment_log"] .= $response->ResponseText();

			$vmLogger->debug( $d['order_payment_log']);

			return True;
		}
		// Payment Declined
		else {
			$vmLogger->err( "Transaction Declined. Bank Response: " . $response->ResponseText() );
			$d["order_payment_log"] = $response->ResponseText();
            
			return False;
		}
    }

}
